﻿namespace Microsoft.Samples.PlanMyNight.Web.Tests.Helpers
{
    using System;
    using System.Web;
    using System.Web.Mvc;
    using Microsoft.Samples.PlanMyNight.Infrastructure.Mvc;
    using Microsoft.VisualStudio.TestTools.UnitTesting;
    using Moq;

    [TestClass]
    public class HandleErrorWithContentTypeAttributeFixture
    {
        [TestMethod]
        [ExpectedException(typeof(ArgumentNullException))]
        public void HandleErrorWithoutContextFails()
        {
            new HandleErrorWithContentTypeAttribute().OnException(null);
        }

        [TestMethod]
        public void HandleErrorSetsView()
        {
            var httpResponse = new Mock<HttpResponseBase>();
            httpResponse.Setup(o => o.Clear());
            httpResponse.Setup(o => o.TrySkipIisCustomErrors);

            var httpRequest = new Mock<HttpRequestBase>();
            httpRequest.Setup(o => o.ContentType).Returns(default(string));

            var httpContext = new Mock<HttpContextBase>();
            httpContext.Setup(o => o.Response).Returns(httpResponse.Object);
            httpContext.Setup(o => o.Request).Returns(httpRequest.Object);
            var context = new Mock<ControllerContext>();
            context.Setup(o => o.HttpContext).Returns(httpContext.Object);

            var exceptionContext = new ExceptionContext(context.Object, new ArgumentNullException("arg"));
            exceptionContext.RouteData.Values["controller"] = "TestController";
            exceptionContext.RouteData.Values["action"] = "TestAction";

            var controller = new Mock<ControllerBase>();
            controller.Object.TempData = new TempDataDictionary();
            exceptionContext.Controller = controller.Object;

            var filter = new HandleErrorWithContentTypeAttribute();
            filter.OnException(exceptionContext);
            var result = exceptionContext.Result as ViewResult;

            Assert.IsNotNull(result);
            Assert.IsNotNull(result.ViewData.Model);
            Assert.IsInstanceOfType(result.ViewData.Model, typeof(HandleErrorInfo));
            httpContext.VerifyAll();
            httpRequest.VerifyAll();
            httpRequest.VerifyAll();
        }
        
        [TestMethod]
        public void HandleErrorSetsJsonResult()
        {
            var httpResponse = new Mock<HttpResponseBase>();
            httpResponse.Setup(o => o.Clear());
            httpResponse.Setup(o => o.TrySkipIisCustomErrors);

            var httpRequest = new Mock<HttpRequestBase>();
            httpRequest.Setup(o => o.ContentType).Returns("application/json");
            httpRequest.Setup(o => o.Url).Returns(new Uri("http://planmynight.net/"));

            var httpContext = new Mock<HttpContextBase>();
            httpContext.Setup(o => o.Response).Returns(httpResponse.Object);
            httpContext.Setup(o => o.Request).Returns(httpRequest.Object);
            var context = new Mock<ControllerContext>();
            context.Setup(o => o.HttpContext).Returns(httpContext.Object);

            var exceptionContext = new ExceptionContext(context.Object, new ArgumentNullException("arg"));
            exceptionContext.RouteData.Values["controller"] = "TestController";
            exceptionContext.RouteData.Values["action"] = "TestAction";

            var controller = new Mock<ControllerBase>();
            controller.Object.TempData = new TempDataDictionary();
            exceptionContext.Controller = controller.Object;

            var filter = new HandleErrorWithContentTypeAttribute();
            filter.OnException(exceptionContext);
            var result = exceptionContext.Result as JsonResult;

            Assert.IsNotNull(result);
            httpContext.VerifyAll();
            httpRequest.VerifyAll();
            httpRequest.VerifyAll();
        }
    }
}

